<?php

namespace App\Http\Controllers\API\Map;

use App\Http\Controllers\Controller;
use App\Http\Traits\ResponseTrait;
use App\Repositries\AuctionRepository;
use Illuminate\Http\Request;

class MapController extends Controller
{
    use ResponseTrait;
    public $auctionRepository;

    public function __construct(AuctionRepository $auctionRepository)
    {
        $this->auctionRepository = $auctionRepository;
    }

    public function __invoke(Request $request)
    {
        $filters = $request->all();
        $map = $this->auctionRepository->map($filters);

        return $this->response(data: $map);
    }
}
