<?php

namespace App\Http\Controllers\API\Intro;

use App\Http\Controllers\Controller;
use App\Http\Traits\ResponseTrait;
use App\Models\Intro;
use App\Repositries\IntroRepository;

class IntroController extends Controller
{
    use ResponseTrait;
    public $introRepository;


    public function __construct(IntroRepository $introRepository)
    {
        $this->introRepository = $introRepository;
    }

    public function index()
    {
        $intros =  $this->introRepository->index();
        return $this->response(
            data: $intros
        );
    }

    public function show(string $id)
    {
        $intro =  $this->introRepository->show($id);

        return $this->response(
            data: $intro
        );
    }
}
