<?php

namespace App\Http\Controllers\API\Country;

use App\Http\Controllers\Controller;
use App\Http\Traits\ResponseTrait;
use App\Models\City;
use App\Models\Country;
use App\Repositries\MainRepository;

class CountryController extends Controller
{
    use ResponseTrait;

    public $mainRepository, $country, $city;

    public function __construct(MainRepository $mainRepository, Country $country, City $city)
    {
        $this->mainRepository = $mainRepository;
        $this->country = $country;
        $this->city = $city;
    }
    public function index()
    {
        $countries = $this->mainRepository->index($this->country);
        return $this->response(data: $countries);
    }

    public function cities($id)
    {
        $country = $this->mainRepository->show($this->country, $id);
        return $this->response(data: $country->cities);
    }

    public function areas($id)
    {
        $city = $this->mainRepository->show($this->city, $id);
        return $this->response(data: $city->areas);
    }
}
