<?php

namespace App\Http\Controllers\API\Category;

use App\Http\Controllers\Controller;
use App\Http\Traits\ResponseTrait;
use App\Repositries\CategoryRepository;

class CategoryController extends Controller
{
    use ResponseTrait;
    public $categoryRepository;


    public function __construct(CategoryRepository $categoryRepository)
    {
        $this->categoryRepository = $categoryRepository;
    }

    public function index()
    {
        $categories = $this->categoryRepository->index();
        return $this->response(
            data: $categories
        );
    }

    public function show(string $id)
    {
        $category = $this->categoryRepository->show($id);

        return $this->response(
            data: $category,
        );
    }
}
