<?php

namespace App\Http\Controllers\API\Auction;

use App\Http\Controllers\Controller;
use App\Http\Traits\ResponseTrait;
use App\Repositries\MainRepository;

class SearchController extends Controller
{
    use ResponseTrait;
    public $model, $searchRepository;

    public function __construct(MainRepository $searchRepository)
    {
        $this->searchRepository = $searchRepository;
        $this->model = auth('client')->user()->searches();
    }
    public function __invoke()
    {
        $data = $this->searchRepository->index($this->model);
        return $this->response(data: $data);
    }
}
