<?php

namespace App\Http\Controllers\API\Auction;

use App\Http\Controllers\Controller;
use App\Http\Traits\ResponseTrait;
use App\Repositries\AuctionRepository;

class AuctionController extends Controller
{
    use ResponseTrait;
    public $auctionRepository;

    public function __construct(AuctionRepository $auctionRepository)
    {
        $this->auctionRepository = $auctionRepository;
    }


    public function index()
    {
        $filters = request()->all();
        $auctions = $this->auctionRepository->index($filters);
        return $this->response(data: $auctions);
    }

    public function show(string $id)
    {
        $auction = $this->auctionRepository->show($id);
        return $this->response(data: $auction);
    }
}
