<?php

namespace App\Http\Controllers\API\Article;

use App\Http\Controllers\Controller;
use App\Http\Traits\ResponseTrait;
use App\Repositries\ArticleRepository;

class ArticleController extends Controller
{
    use ResponseTrait;
    public $articleRepository;
    public function __construct(ArticleRepository $articleRepository)
    {
        $this->articleRepository = $articleRepository;
    }
    public function index()
    {
        $articles =  $this->articleRepository->index();
        return $this->response(data: $articles);
    }

    public function show(string $id)
    {
        $article =  $this->articleRepository->show($id);

        return $this->response(data: $article);
    }
}
