<?php

namespace App\Console\Commands;

use App\Repositries\AuctionRepository;
use Illuminate\Console\Command;

class StartTheComingAuctions extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'start:auction';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Start the coming auctions that have not started yet';

    /**
     * Execute the console command.
     */
    public function handle(AuctionRepository $auctionRepository)
    {
        $auctions = $auctionRepository->start();


        foreach ($auctions as $auction)
            $auctionRepository->update($auction->id, ['type' => 'current']);
    }
}
